
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
paul_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
john_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
george_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")


# Set objective function
m.setObjective(3.06 * laura_hours + 7.24 * paul_hours + 5.89 * bill_hours + 6.62 * john_hours + 9.56 * george_hours + 6.55 * jean_hours, gp.GRB.MINIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'upper_bound': 183, 'coeffs': [2, 5, 1, 3, 9, 11]},
    'r1': {'upper_bound': 267, 'coeffs': [4, 1, 6, 6, 9, 10]},
    'r2': {'upper_bound': 240, 'coeffs': [8, 11, 3, 3, 5, 7]},
    'r3': {'upper_bound': 125, 'coeffs': [10, 6, 10, 2, 3, 9]},
    'r4': {'upper_bound': 173, 'coeffs': [10, 11, 9, 11, 2, 5]}
}
variables = [laura_hours, paul_hours, bill_hours, john_hours, george_hours, jean_hours]

for resource, data in resource_constraints.items():
    m.addConstr(gp.LinExpr(data['coeffs'], variables) <= data['upper_bound'], name=resource)


m.addConstr(2*laura_hours + 11*jean_hours >= 21)
m.addConstr(2*laura_hours + 5*paul_hours >= 17)
m.addConstr(1*bill_hours + 11*jean_hours >= 26)
m.addConstr(5*paul_hours + 11*jean_hours >= 28)
m.addConstr(2*laura_hours + 9*george_hours >= 19)
m.addConstr(2*laura_hours + 3*john_hours >= 30)
m.addConstr(2*laura_hours + 5*paul_hours + 1*bill_hours + 3*john_hours + 9*george_hours + 11*jean_hours >= 30)
m.addConstr(4*laura_hours + 6*john_hours >= 37)
m.addConstr(6*bill_hours + 6*john_hours >= 15)
m.addConstr(1*paul_hours + 9*george_hours >= 25)
m.addConstr(9*george_hours + 10*jean_hours >= 37)

m.addConstr(-5*laura_hours + 3*paul_hours >= 0)
m.addConstr(-1*laura_hours + 10*george_hours >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

