
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
x1, x2, x3, x4, x5, x6 = m.addVars(6, name=['Laura', 'Paul', 'Bill', 'John', 'George', 'Jean'])

# Objective function (example coefficients)
m.setObjective(x1 + 2*x2 + 3*x3 + x4 + 2*x5 + x6, GRB.MINIMIZE)

# Constraints
m.addConstr(-5*x1 + 3*x2 >= 0, name='constraint1')
m.addConstr(-x1 + 10*x5 >= 0, name='constraint2')

# Add other constraints here
m.addConstr(x4 + x5 <= 94, name='paperwork_constraint')
m.addConstr(x1 + x2 + x3 + x4 + x5 + x6 >= 15, name='total_hours_minimum')

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(f'{v.varName}: {v.x}')

print('Obj:', m.objVal)
