
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0, ub=None)  # hours worked by Laura
    x1 = model.addVar(name="x1", lb=0, ub=None)  # hours worked by Paul
    x2 = model.addVar(name="x2", lb=0, ub=None)  # hours worked by Bill
    x3 = model.addVar(name="x3", lb=0, ub=None)  # hours worked by John
    x4 = model.addVar(name="x4", lb=0, ub=None)  # hours worked by George
    x5 = model.addVar(name="x5", lb=0, ub=None)  # hours worked by Jean

    # Objective function
    model.setObjective(3.06*x0 + 7.24*x1 + 5.89*x2 + 6.62*x3 + 9.56*x4 + 6.55*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    # Paperwork competence rating constraints
    model.addConstr(2*x0 + 5*x1 + x2 + 3*x3 + 9*x4 + 11*x5 <= 183)
    model.addConstr(2*x0 + 5*x1 <= 183 - x2 - 3*x3 - 9*x4 - 11*x5)
    # Organization score constraints
    model.addConstr(4*x0 + x1 + 6*x2 + 6*x3 + 9*x4 + 10*x5 <= 267)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Paul: ", x1.varValue)
        print("Hours worked by Bill: ", x2.varValue)
        print("Hours worked by John: ", x3.varValue)
        print("Hours worked by George: ", x4.varValue)
        print("Hours worked by Jean: ", x5.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
