
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
    potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
    vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")


    # Set objective function
    m.setObjective(7*zinc + 3*iron + 5*potassium + 1*vitamin_b5, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10.05*zinc + 10.59*vitamin_b5 >= 33, "c0")
    m.addConstr(9.7*iron + 10.59*vitamin_b5 >= 54, "c1")
    m.addConstr(9.7*iron + 3.38*potassium >= 40, "c2")
    m.addConstr(10.05*zinc + 9.7*iron >= 35, "c3")
    m.addConstr(10.05*zinc + 9.7*iron + 3.38*potassium + 10.59*vitamin_b5 >= 35, "c4")
    m.addConstr(0.29*zinc + 7.56*iron >= 44, "c5")
    m.addConstr(7.56*iron + 0.03*potassium >= 25, "c6")
    m.addConstr(0.03*potassium + 9.46*vitamin_b5 >= 19, "c7")
    m.addConstr(0.29*zinc + 7.56*iron + 0.03*potassium + 9.46*vitamin_b5 >= 19, "c8")
    m.addConstr(-9*iron + 2*vitamin_b5 >= 0, "c9")
    m.addConstr(9*potassium - 8*vitamin_b5 >= 0, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('zinc:', zinc.x)
        print('iron:', iron.x)
        print('potassium:', potassium.x)
        print('vitamin_b5:', vitamin_b5.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
