
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_zinc", lb=0)
    x2 = model.addVar(name="milligrams_of_iron", lb=0)
    x3 = model.addVar(name="milligrams_of_potassium", lb=0)
    x4 = model.addVar(name="milligrams_of_vitamin_B5", lb=0)

    # Objective function
    model.setObjective(7 * x1 + 3 * x2 + 5 * x3 + x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10.05 * x1 + 10.59 * x4 >= 33)
    model.addConstr(9.7 * x2 + 10.59 * x4 >= 54)
    model.addConstr(9.7 * x2 + 3.38 * x3 >= 40)
    model.addConstr(10.05 * x1 + 9.7 * x2 >= 35)
    model.addConstr(10.05 * x1 + 9.7 * x2 + 3.38 * x3 + 10.59 * x4 >= 35)
    model.addConstr(0.29 * x1 + 7.56 * x2 >= 44)
    model.addConstr(7.56 * x2 + 0.03 * x3 >= 25)
    model.addConstr(0.03 * x3 + 9.46 * x4 >= 19)
    model.addConstr(0.29 * x1 + 7.56 * x2 + 0.03 * x3 + 9.46 * x4 >= 19)
    model.addConstr(-9 * x2 + 2 * x4 >= 0)
    model.addConstr(9 * x3 - 8 * x4 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of zinc: {x1.varValue}")
        print(f"Milligrams of iron: {x2.varValue}")
        print(f"Milligrams of potassium: {x3.varValue}")
        print(f"Milligrams of vitamin B5: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
