
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_potassium", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="milligrams_of_calcium")

    # Objective function
    model.setObjective(4 * x1 + x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13 * x1 + 10 * x2 >= 27, name="energy_stability_index_min")
    model.addConstr(14 * x1 + 3 * x2 >= 10, name="digestive_support_index_min")
    model.addConstr(-x1 + 3 * x2 >= 0, name="linear_constraint")
    model.addConstr(13 * x1 + 10 * x2 <= 61, name="energy_stability_index_max")
    model.addConstr(14 * x1 + 3 * x2 <= 37, name="digestive_support_index_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of potassium: {x1.varValue}")
        print(f"Milligrams of calcium: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
