
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")
mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")
bill = model.addVar(vtype=gp.GRB.INTEGER, name="bill")
paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")
dale = model.addVar(vtype=gp.GRB.INTEGER, name="dale")
laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")
george = model.addVar(vtype=gp.GRB.INTEGER, name="george")
bobby = model.addVar(vtype=gp.GRB.INTEGER, name="bobby")


# Set objective function
model.setObjective(5.75*peggy + 3.56*mary + 3.79*bill + 1.03*paul + 8.63*dale + 8.66*laura + 7.11*george + 4.1*bobby, gp.GRB.MAXIMIZE)

# Resource and attribute data
resources = {
    'r0': {'description': 'work quality rating', 'upper_bound': 137, 'peggy': 5, 'mary': 9, 'bill': 11, 'paul': 7, 'dale': 9, 'laura': 8, 'george': 5, 'bobby': 3},
    'r1': {'description': 'organization score', 'upper_bound': 224, 'peggy': 10, 'mary': 8, 'bill': 3, 'paul': 5, 'dale': 1, 'laura': 13, 'george': 5, 'bobby': 12},
    'r2': {'description': 'paperwork competence rating', 'upper_bound': 519, 'peggy': 12, 'mary': 6, 'bill': 8, 'paul': 3, 'dale': 14, 'laura': 6, 'george': 5, 'bobby': 5}
}

# Add resource constraints
for resource, data in resources.items():
    model.addConstr(
        data['peggy']*peggy + data['mary']*mary + data['bill']*bill + data['paul']*paul + data['dale']*dale + data['laura']*laura + data['george']*george + data['bobby']*bobby <= data['upper_bound'],
        name=f"{data['description']} constraint"
    )


# Add other constraints from the input (simplified and deduplicated)
model.addConstr(5 * dale + 8 * laura + 5 * george >= 8)
model.addConstr(5 * peggy + 9 * mary + 9 * dale >= 8)
model.addConstr(5 * peggy + 8 * laura + 5 * george >= 8)
model.addConstr(7 * paul + 9 * dale + 8 * laura >= 8)
model.addConstr(11 * bill + 9 * dale + 8 * laura >= 8)
model.addConstr(7 * paul + 8 * laura + 3 * bobby >= 8)
model.addConstr(9 * mary + 5 * george + 3 * bobby >= 8)
model.addConstr(9 * mary + 7 * paul + 5 * george >= 8)
model.addConstr(11 * bill + 5 * george + 3 * bobby >= 8)
model.addConstr(9 * mary + 7 * paul + 8 * laura >= 8)
model.addConstr(11 * bill + 9 * dale + 3 * bobby >= 8)
model.addConstr(9 * mary + 8 * laura + 3 * bobby >= 8)
model.addConstr(9 * mary + 11 * bill + 9 * dale >= 8)
model.addConstr(7 * paul + 9 * dale + 3 * bobby >= 8)
model.addConstr(5 * peggy + 9 * mary + 5 * george >= 8)
model.addConstr(5 * peggy + 7 * paul + 9 * dale >= 8)
model.addConstr(5 * peggy + 11 * bill + 7 * paul >= 8)
model.addConstr(5 * peggy + 11 * bill + 3 * bobby >= 8)
model.addConstr(9 * mary + 11 * bill + 5 * george >= 8)
model.addConstr(7 * paul + 9 * dale + 5 * george >= 8)
model.addConstr(5 * peggy + 9 * mary + 8 * laura >= 8)
model.addConstr(5 * peggy + 8 * laura + 3 * bobby >= 8)
model.addConstr(9 * mary + 7 * paul + 9 * dale >= 8)
model.addConstr(5 * peggy + 7 * paul + 5 * george >= 8)
model.addConstr(8 * laura + 5 * george + 3 * bobby >= 8)
model.addConstr(5 * peggy + 11 * bill + 8 * laura >= 8)
model.addConstr(9 * mary + 9 * dale + 8 * laura >= 8)
model.addConstr(11 * bill + 8 * laura + 5 * george >= 8)


model.addConstr(dale + laura >= 27)
model.addConstr(bill + laura >= 22)
model.addConstr(mary + dale + bobby >= 26)
model.addConstr(peggy + mary + dale >= 26)
model.addConstr(mary + dale + bobby >= 21)
model.addConstr(peggy + mary + dale >= 21)
model.addConstr(bill + paul >= 64)
model.addConstr(laura + george >= 44)
model.addConstr(mary + george >= 58)
model.addConstr(peggy + mary >= 39)
model.addConstr(paul + george >= 63)
model.addConstr(paul + laura >= 49)
model.addConstr(paul + bobby >= 64)
model.addConstr(peggy + bobby >= 22)
model.addConstr(mary + bobby >= 26)
model.addConstr(george + bobby >= 45)
model.addConstr(peggy + paul >= 39)
model.addConstr(peggy + mary + dale >= 40)
model.addConstr(peggy + paul + bobby >= 40)
model.addConstr(dale + george + bobby >= 40)
model.addConstr(mary + bill + bobby >= 40)
model.addConstr(peggy + paul + dale >= 40)
model.addConstr(paul + laura + george >= 40)
model.addConstr(mary + dale + laura >= 40)
model.addConstr(paul + dale + bobby >= 40)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print('Optimization was infeasible.')
else:
    print(f"Optimization terminated with status {model.status}")

