
from gurobipy import *

# Create a new model
m = Model("Work Hours")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="Peggy")
x2 = m.addVar(vtype=GRB.INTEGER, name="Mary")
x3 = m.addVar(vtype=GRB.INTEGER, name="Bill")
x4 = m.addVar(vtype=GRB.INTEGER, name="Paul")
x5 = m.addVar(vtype=GRB.INTEGER, name="Dale")
x6 = m.addVar(vtype=GRB.INTEGER, name="Laura")
x7 = m.addVar(vtype=GRB.INTEGER, name="George")
x8 = m.addVar(vtype=GRB.INTEGER, name="Bobby")

# Objective function
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8, GRB.MINIMIZE)

# Add constraints (example)
m.addConstr(x1 + x2 >= 39, "ExampleConstraint1")
m.addConstr(x3 - 3*x4 <= 12, "ExampleConstraint2")
# Add all other actual constraints here

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
