
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = gp.LVar(lb=0, name="x1")
x2 = gp.LVar(lb=0, name="x2")
x3 = gp.LVar(lb=0, name="x3")
x4 = gp.LVar(lb=0, name="x4")
x5 = gp.LVar(lb=0, name="x5")
x6 = gp.LVar(lb=0, name="x6")
x7 = gp.LVar(lb=0, name="x7")
x8 = gp.LVar(lb=0, name="x8")

# Objective function
m.setObjective(5.75*x1 + 3.56*x2 + 3.79*x3 + 1.03*x4 + 8.63*x5 + 8.66*x6 + 7.11*x7 + 4.1*x8, gp.GRB.MAXIMIZE)

# Constraints
# Add organization score constraints
m.addConstr(5*x1 + 9*x2 + 11*x3 + 7*x4 + 9*x5 + 8*x6 + 5*x7 + 3*x8 <= 137)
m.addConstr(10*x1 + 8*x2 + 3*x3 + 5*x4 + 1*x5 + 13*x6 + 5*x7 + 12*x8 <= 224)
m.addConstr(12*x1 + 6*x2 + 8*x3 + 3*x4 + 14*x5 + 6*x6 + 5*x7 + 5*x8 <= 519)

# Add constraints for work quality rating
m.addConstr(9*x5 + 9*x6 + 5*x7 >= 14)
m.addConstr(5*x1 + 9*x2 + 9*x5 >= 14)
m.addConstr(5*x1 + 8*x6 + 5*x7 >= 14)
m.addConstr(7*x4 + 9*x5 + 8*x6 >= 14)
m.addConstr(11*x3 + 9*x5 + 8*x6 >= 14)
m.addConstr(7*x4 + 8*x6 + 3*x8 >= 14)
m.addConstr(9*x2 + 5*x7 + 4.1*x8 >= 14)

# Add integer constraints
x1.Integers = True
x2.Integers = True
x3.Integers = True
x4.Integers = True
x5.Integers = True
x6.Integers = True
x7.Integers = True
x8.Integers = True

# Solve the model
m.optimize()

if m.status == gp.GRB.Status.OPTIMAL:
    print("Optimal solution found.")
    print("Objective: ", m.objval)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
    print("x6: ", x6.varValue)
    print("x7: ", x7.varValue)
    print("x8: ", x8.varValue)
else:
    print("No optimal solution found.")
