
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="x0") # hours worked by Peggy
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="x1") # hours worked by Ringo
    x2 = model.addVar(vtype=GRB.INTEGER, name="x2") # hours worked by Paul
    x3 = model.addVar(vtype=GRB.CONTINUOUS, name="x3") # hours worked by John


    # Set objective function
    model.setObjective(8.42*x0**2 + 7.34*x0*x1 + 8.88*x0*x2 + 4.77*x0*x3 + 4.14*x1**2 + 5.67*x1*x2 + 5.93*x1*x3 + 4.4*x2**2 + 3.85*x2*x3 + 1.71*x3**2 + 5.22*x1 + 8.13*x2 + 2.91*x3, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x2 + 7*x3 >= 12, "c0")
    model.addConstr(12*x0 + 5*x2 >= 23, "c1")
    model.addConstr(6*x1**2 + 5*x2**2 + 7*x3**2 >= 23, "c2")
    model.addConstr(12*x0 + 6*x1 + 5*x2 + 7*x3 >= 23, "c3")
    model.addConstr(-4*x1**2 + 4*x3**2 >= 0, "c4")
    model.addConstr(4*x0**2 - 5*x2**2 >= 0, "c5")
    model.addConstr(12*x0 + 6*x1 + 7*x3 <= 60, "c6")
    model.addConstr(12*x0 + 5*x2 + 7*x3 <= 34, "c7")
    model.addConstr(12*x0 + 6*x1 + 5*x2 <= 113, "c8")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
