
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Peggy', vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name='hours_worked_by_Ringo', vtype=gurobi.GRB.CONTINUOUS, lb=0)
    x3 = model.addVar(name='hours_worked_by_Paul', vtype=gurobi.GRB.INTEGER, lb=0)
    x4 = model.addVar(name='hours_worked_by_John', vtype=gurobi.GRB.CONTINUOUS, lb=0)

    # Define the objective function
    model.setObjective(8.42*x1**2 + 7.34*x1*x2 + 8.88*x1*x3 + 4.77*x1*x4 + 
                       4.14*x2**2 + 5.67*x2*x3 + 5.93*x2*x4 + 
                       4.4*x3**2 + 3.85*x3*x4 + 1.71*x4**2 + 
                       5.22*x2 + 8.13*x3 + 2.91*x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*x1 <= 122)
    model.addConstr(6*x2 <= 122)
    model.addConstr(5*x3 <= 122)
    model.addConstr(7*x4 <= 122)
    model.addConstr(5*x3 + 7*x4 >= 12)
    model.addConstr(12*x1 + 5*x3 >= 23)
    model.addConstr(6*x2**2 + 5*x3**2 + 7*x4**2 >= 23)
    model.addConstr(12*x1 + 6*x2 + 5*x3 + 7*x4 >= 23)
    model.addConstr(-4*x2**2 + 4*x4**2 >= 0)
    model.addConstr(4*x1**2 - 5*x3**2 >= 0)
    model.addConstr(12*x1 + 6*x2 + 7*x4 <= 60)
    model.addConstr(12*x1 + 5*x3 + 7*x4 <= 34)
    model.addConstr(12*x1 + 6*x2 + 5*x3 <= 113)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Peggy: ', x1.varValue)
        print('Hours worked by Ringo: ', x2.varValue)
        print('Hours worked by Paul: ', x3.varValue)
        print('Hours worked by John: ', x4.varValue)
    else:
        print('No optimal solution found')

optimize_problem()
