
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("office_supplies")

# Create variables
staplers = m.addVar(vtype=GRB.INTEGER, name="staplers")
color_printers = m.addVar(vtype=GRB.INTEGER, name="color_printers")
yellow_highlighters = m.addVar(vtype=GRB.INTEGER, name="yellow_highlighters")

# Set objective function
m.setObjective(1*staplers + 9*color_printers + 9*yellow_highlighters, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*staplers + 9*color_printers + 27*yellow_highlighters <= 187, "c0")
m.addConstr(9*staplers + 26*color_printers + 32*yellow_highlighters <= 220, "c1")
m.addConstr(9*staplers + 26*color_printers + 32*yellow_highlighters >= 37, "c2")
m.addConstr(3*staplers + 27*yellow_highlighters <= 176, "c3")
m.addConstr(3*staplers + 9*color_printers <= 145, "c4")
m.addConstr(3*staplers + 9*color_printers + 27*yellow_highlighters <= 145, "c5")
m.addConstr(26*color_printers + 32*yellow_highlighters <= 185, "c6")
m.addConstr(9*staplers + 32*yellow_highlighters <= 173, "c7")
m.addConstr(9*staplers + 26*color_printers + 32*yellow_highlighters <= 173, "c8")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('staplers:', staplers.x)
    print('color_printers:', color_printers.x)
    print('yellow_highlighters:', yellow_highlighters.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

