
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="staplers")
x1 = m.addVar(vtype=GRB.INTEGER, name="color_printers")
x2 = m.addVar(vtype=GRB.INTEGER, name="yellow_highlighters")

# Set the objective function
m.setObjective(1*x0 + 9*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 9*x1 <= 145)
m.addConstr(3*x0 + 27*x2 <= 176)
m.addConstr(3*x0 + 9*x1 + 27*x2 <= 145)
m.addConstr(9*x0 + 26*x1 + 32*x2 >= 37)
m.addConstr(26*x1 + 32*x2 <= 185)
m.addConstr(9*x0 + 32*x2 <= 173)
m.addConstr(9*x0 + 26*x1 + 32*x2 <= 173)

# Optimize the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
