
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    staplers = model.addVar(name="staplers", vtype=gurobi.GRB.INTEGER)
    color_printers = model.addVar(name="color_printers", vtype=gurobi.GRB.INTEGER)
    yellow_highlighters = model.addVar(name="yellow_highlighters", vtype=gurobi.GRB.INTEGER)

    # Define objective function
    model.setObjective(staplers + 9 * color_printers + 9 * yellow_highlighters, gurobi.GRB.MAXIMIZE)

    # Define constraints
    model.addConstr(3 * staplers + 9 * color_printers + 27 * yellow_highlighters <= 187, name="workplace_safety_impact")
    model.addConstr(9 * staplers + 26 * color_printers + 32 * yellow_highlighters <= 220, name="weight")
    model.addConstr(9 * staplers + 26 * color_printers + 32 * yellow_highlighters >= 37, name="combined_weight")
    model.addConstr(3 * staplers + 27 * yellow_highlighters <= 176, name="staplers_yellow_highlighters_safety")
    model.addConstr(3 * staplers + 9 * color_printers <= 145, name="staplers_color_printers_safety")
    model.addConstr(3 * staplers + 9 * color_printers + 27 * yellow_highlighters <= 145, name="all_safety")
    model.addConstr(26 * color_printers + 32 * yellow_highlighters <= 185, name="color_printers_yellow_highlighters_weight")
    model.addConstr(9 * staplers + 32 * yellow_highlighters <= 173, name="staplers_yellow_highlighters_weight")
    model.addConstr(9 * staplers + 26 * color_printers + 32 * yellow_highlighters <= 173, name="all_weight")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Staplers: {staplers.varValue}")
        print(f"Color Printers: {color_printers.varValue}")
        print(f"Yellow Highlighters: {yellow_highlighters.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
