
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Create variables
pickles = m.addVar(vtype=gp.GRB.INTEGER, name="pickles")
black_beans = m.addVar(vtype=gp.GRB.INTEGER, name="black_beans")
pizza_slices = m.addVar(vtype=gp.GRB.INTEGER, name="pizza_slices")
ham_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")


# Set objective function
m.setObjective(1 * pickles + 8 * black_beans + 2 * pizza_slices + 4 * ham_sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(pizza_slices + ham_sandwiches >= 14)
m.addConstr(black_beans + ham_sandwiches >= 7)
m.addConstr(pickles + pizza_slices >= 8)
m.addConstr(pizza_slices + ham_sandwiches <= 33)
m.addConstr(black_beans + pizza_slices <= 64)
m.addConstr(black_beans + ham_sandwiches <= 58)
m.addConstr(pickles + pizza_slices <= 33)
m.addConstr(pickles + ham_sandwiches <= 30)
m.addConstr(pickles + black_beans + pizza_slices <= 69)
m.addConstr(black_beans + pizza_slices + ham_sandwiches <= 28)
m.addConstr(pickles + black_beans + pizza_slices + ham_sandwiches <= 28)
m.addConstr(8 * pickles + 6 * black_beans + 1 * pizza_slices + 7 * ham_sandwiches <= 73)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pickles:', pickles.x)
    print('black_beans:', black_beans.x)
    print('pizza_slices:', pizza_slices.x)
    print('ham_sandwiches:', ham_sandwiches.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

