
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='pickles', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='black_beans', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='slices_of_pizza', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='ham_sandwiches')

# Objective function
m.setObjective(x1 + 8*x2 + 2*x3 + 4*x4, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(8*x1 + 6*x2 + x3 + 7*x4 <= 73)
m.addConstr(x3 + 7*x4 >= 14)
m.addConstr(6*x2 + 7*x4 >= 7)
m.addConstr(8*x1 + x3 >= 8)
m.addConstr(x3 + 7*x4 <= 33)
m.addConstr(6*x2 + x3 <= 64)
m.addConstr(6*x2 + 7*x4 <= 58)
m.addConstr(8*x1 + x3 <= 33)
m.addConstr(8*x1 + 7*x4 <= 30)
m.addConstr(8*x1 + 6*x2 + x3 <= 69)
m.addConstr(6*x2 + x3 + 7*x4 <= 28)
m.addConstr(8*x1 + 6*x2 + x3 + 7*x4 <= 28)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Pickles: ', x1.varValue)
    print('Black beans: ', x2.varValue)
    print('Slices of pizza: ', x3.varValue)
    print('Ham sandwiches: ', x4.varValue)
else:
    print('The model is infeasible')
