
import gurobipy as gp

# Create a new model
m = gp.Model("optimize_work_hours")

# Create variables
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")


# Set objective
m.setObjective(8.85 * mary + 6.71 * george + 3.86 * jean + 8.83 * ringo + 2.28 * paul, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * george + 10 * paul >= 18)
m.addConstr(28 * george + 10 * jean + 35 * ringo >= 37)
m.addConstr(14 * mary + 35 * ringo + 10 * paul >= 37)
m.addConstr(14 * mary + 28 * george + 10 * jean >= 37)
m.addConstr(14 * mary + 28 * george + 35 * ringo >= 37)
m.addConstr(28 * george + 10 * jean + 35 * ringo >= 38)
m.addConstr(14 * mary + 35 * ringo + 10 * paul >= 38)
m.addConstr(14 * mary + 28 * george + 10 * jean >= 38)
m.addConstr(14 * mary + 28 * george + 35 * ringo >= 38)

# ... (rest of the constraints from the JSON "constraints" section)

m.addConstr(34 * mary + 2 * george + 12 * jean <= 256)
m.addConstr(34 * mary + 2 * george + 12 * jean + 24 * ringo + 31 * paul <= 256)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

