
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by John
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Jean
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Peggy
    x3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # hours worked by George


    # Set objective function
    model.setObjective(1.99*x0**2 + 8.52*x0*x1 + 3.5*x0*x2 + 8.82*x0*x3 + 4.38*x1**2 + 5.59*x1*x3 + 4.65*x2**2 + 3.94*x2*x3 + 8.1*x3**2 + 3.24*x0 + 3.63*x1 + 8.56*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x0 <= 77, "c0")
    model.addConstr(11*x1 <= 77, "c1")
    model.addConstr(13*x2 <= 77, "c2")
    model.addConstr(1*x3 <= 77, "c3")
    model.addConstr(13*x2 + 1*x3 >= 6, "c4")
    model.addConstr(3*x0 + 13*x2 >= 6, "c5")
    model.addConstr(3*x0 + 11*x1 + 13*x2 >= 13, "c6")
    model.addConstr((3*x0)**2 + (13*x2)**2 + (1*x3)**2 >= 13, "c7")
    model.addConstr(11*x1 + 13*x2 + 1*x3 >= 13, "c8")
    model.addConstr(3*x0 + 11*x1 + 13*x2 >= 13, "c9")
    model.addConstr(3*x0 + 13*x2 + 1*x3 >= 13, "c10")
    model.addConstr(11*x1 + 13*x2 + 1*x3 >= 13, "c11")
    model.addConstr(3*x0 + 11*x1 + 13*x2 >= 10, "c12")
    model.addConstr(3*x0 + 13*x2 + 1*x3 >= 10, "c13")
    model.addConstr(11*x1 + 13*x2 + 1*x3 >= 10, "c14")
    model.addConstr(13*x2 + 1*x3 <= 42, "c15")
    model.addConstr(3*x0 + 13*x2 + 1*x3 <= 58, "c16")
    model.addConstr((3*x0)**2 + (11*x1)**2 + (1*x3)**2 <= 66, "c17")
    model.addConstr(3*x0 + 11*x1 + 13*x2 + 1*x3 <= 66, "c18")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
