
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_John", vtype=gp.GRB.INTEGER)  # integer constraint for x1
x2 = m.addVar(name="hours_worked_by_Jean")
x3 = m.addVar(name="hours_worked_by_Peggy")
x4 = m.addVar(name="hours_worked_by_George")

# Objective function
m.setObjective(1.99*x1**2 + 8.52*x1*x2 + 3.5*x1*x3 + 8.82*x1*x4 + 4.38*x2**2 + 5.59*x2*x4 + 4.65*x3**2 + 3.94*x3*x4 + 8.1*x4**2 + 3.24*x1 + 3.63*x2 + 8.56*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x1 <= 77)
m.addConstr(11*x2 <= 77)
m.addConstr(13*x3 <= 77)
m.addConstr(1*x4 <= 77)
m.addConstr(13*x3 + 1*x4 >= 6)
m.addConstr(3*x1 + 13*x3 >= 6)
m.addConstr(3*x1 + 11*x2 + 13*x3 >= 13)
m.addConstr(3**2*x1**2 + 13**2*x3**2 + 1**2*x4**2 >= 13)
m.addConstr(11*x2 + 13*x3 + 1*x4 >= 13)
m.addConstr(3*x1 + 13*x3 + 1*x4 >= 13)
m.addConstr(11*x2 + 13*x3 + 1*x4 >= 13)
m.addConstr(3*x1 + 11*x2 + 13*x3 >= 10)
m.addConstr(3*x1 + 13*x3 + 1*x4 >= 10)
m.addConstr(11*x2 + 13*x3 + 1*x4 >= 10)
m.addConstr(13*x3 + 1*x4 <= 42)
m.addConstr(3*x1 + 13*x3 + 1*x4 <= 58)
m.addConstr(3**2*x1**2 + 11**2*x2**2 + 1**2*x4**2 <= 66)
m.addConstr(3*x1 + 11*x2 + 13*x3 + 1*x4 <= 66)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by John: {x1.varValue}")
    print(f"Hours worked by Jean: {x2.varValue}")
    print(f"Hours worked by Peggy: {x3.varValue}")
    print(f"Hours worked by George: {x4.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
