
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
steaks = m.addVar(vtype=gp.GRB.INTEGER, name="steaks")
milkshakes = m.addVar(vtype=gp.GRB.INTEGER, name="milkshakes")
black_beans = m.addVar(vtype=gp.GRB.INTEGER, name="black_beans")
chicken_thighs = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_thighs")

# Set objective function
m.setObjective(2.74 * steaks + 5.05 * milkshakes + 4.98 * black_beans + 6.54 * chicken_thighs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * steaks + 4 * milkshakes >= 24)
m.addConstr(5 * steaks + 2 * chicken_thighs >= 11)
m.addConstr(black_beans + 9 * chicken_thighs >= 14)
m.addConstr(3 * milkshakes + 9 * chicken_thighs >= 16)
m.addConstr(4 * steaks + 9 * chicken_thighs >= 15)
m.addConstr(3 * milkshakes + black_beans >= 12)
m.addConstr(4 * steaks + 3 * milkshakes + black_beans >= 16)
m.addConstr(4 * steaks + 3 * milkshakes + 9 * chicken_thighs >= 16)
m.addConstr(3 * milkshakes + black_beans + 9 * chicken_thighs >= 16)
m.addConstr(4 * steaks + 3 * milkshakes + black_beans >= 10)
m.addConstr(4 * steaks + 3 * milkshakes + 9 * chicken_thighs >= 10)
m.addConstr(3 * milkshakes + black_beans + 9 * chicken_thighs >= 10)
m.addConstr(4 * steaks + 3 * milkshakes + black_beans >= 10)
m.addConstr(4 * steaks + 3 * milkshakes + 9 * chicken_thighs >= 10)
m.addConstr(3 * milkshakes + black_beans + 9 * chicken_thighs >= 10)


m.addConstr(5 * steaks + 5 * black_beans <= 69)
m.addConstr(4 * milkshakes + 5 * black_beans <= 66)
m.addConstr(5 * steaks + 2 * chicken_thighs <= 64)
m.addConstr(5 * steaks + 4 * milkshakes <= 87)
m.addConstr(5 * steaks + 4 * milkshakes + 2 * chicken_thighs <= 34)
m.addConstr(5 * steaks + 4 * milkshakes + 5 * black_beans <= 68)
m.addConstr(5 * steaks + 5 * black_beans + 2 * chicken_thighs <= 58)
m.addConstr(5 * steaks + 4 * milkshakes + 5 * black_beans + 2 * chicken_thighs <= 58)
m.addConstr(3 * milkshakes + 9 * chicken_thighs <= 67)
m.addConstr(4 * steaks + 9 * chicken_thighs <= 20)
m.addConstr(4 * steaks + 3 * milkshakes <= 62)
m.addConstr(3 * milkshakes + black_beans <= 70)
m.addConstr(4 * steaks + 3 * milkshakes + black_beans + 9 * chicken_thighs <= 70)

# Resource constraints from the provided dictionary
m.addConstr(5 * steaks + 4 * milkshakes + 5 * black_beans + 2 * chicken_thighs <= 114) # Iron
m.addConstr(4 * steaks + 3 * milkshakes + black_beans + 9 * chicken_thighs <= 71) # Carbs


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

