
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
vitamin_b6 = m.addVar(name="vitamin_b6")
vitamin_a = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_a")
vitamin_b5 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b5")


# Set objective function
m.setObjective(1.27 * calcium * vitamin_b6 + 9.65 * vitamin_a**2 + 9.62 * vitamin_b6 + 4.91 * vitamin_a + 6.7 * vitamin_b5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8.07 * calcium + 14.06 * vitamin_b6 >= 27)
m.addConstr(14.06 * vitamin_b6**2 + 8.43 * vitamin_a**2 >= 35)
m.addConstr(8.07 * calcium**2 + 14.41 * vitamin_b5**2 >= 24)
m.addConstr(14.06 * vitamin_b6**2 + 14.41 * vitamin_b5**2 >= 26)
m.addConstr(14.06 * vitamin_b6 + 8.43 * vitamin_a + 14.41 * vitamin_b5 >= 32)
m.addConstr(8.07 * calcium**2 + 14.06 * vitamin_b6**2 + 14.41 * vitamin_b5**2 >= 32)
m.addConstr(8.07 * calcium**2 + 14.06 * vitamin_b6**2 + 8.43 * vitamin_a**2 >= 32)
m.addConstr(14.06 * vitamin_b6 + 8.43 * vitamin_a + 14.41 * vitamin_b5 >= 20)
m.addConstr(8.07 * calcium + 14.06 * vitamin_b6 + 14.41 * vitamin_b5 >= 20)
m.addConstr(8.07 * calcium**2 + 14.06 * vitamin_b6**2 + 8.43 * vitamin_a**2 >= 20)
m.addConstr(14.06 * vitamin_b6 + 8.43 * vitamin_a + 14.41 * vitamin_b5 >= 20)
m.addConstr(8.07 * calcium + 14.06 * vitamin_b6 + 14.41 * vitamin_b5 >= 20)
m.addConstr(8.07 * calcium + 14.06 * vitamin_b6 + 8.43 * vitamin_a >= 20)
m.addConstr(8.07 * calcium + 14.06 * vitamin_b6 + 8.43 * vitamin_a + 14.41 * vitamin_b5 >= 20)
m.addConstr(18.17 * vitamin_a + 14.31 * vitamin_b5 >= 37)
m.addConstr(17.19 * vitamin_b6 + 18.17 * vitamin_a >= 35)
m.addConstr(16.22 * calcium + 18.17 * vitamin_a >= 13)
m.addConstr(16.22 * calcium + 17.19 * vitamin_b6 >= 38)
m.addConstr(16.22 * calcium**2 + 14.31 * vitamin_b5**2 >= 18)
m.addConstr(17.19 * vitamin_b6**2 + 14.31 * vitamin_b5**2 >= 35)
m.addConstr(16.22 * calcium + 17.19 * vitamin_b6 + 18.17 * vitamin_a + 14.31 * vitamin_b5 >= 35)
m.addConstr(-3 * vitamin_b6 + 7 * vitamin_a >= 0)
m.addConstr(-10 * calcium + 8 * vitamin_a >= 0)
m.addConstr(8.43 * vitamin_a + 14.41 * vitamin_b5 <= 119)
m.addConstr(16.22 * calcium + 17.19 * vitamin_b6 <= 47)
m.addConstr(16.22 * calcium**2 + 14.31 * vitamin_b5**2 <= 67)
m.addConstr(17.19 * vitamin_b6**2 + 18.17 * vitamin_a**2 + 14.31 * vitamin_b5**2 <= 97)
m.addConstr(16.22 * calcium + 17.19 * vitamin_b6 + 14.31 * vitamin_b5 <= 156)
m.addConstr(16.22 * calcium**2 + 17.19 * vitamin_b6**2 + 18.17 * vitamin_a**2 <= 51)

m.addConstr(8.07 * calcium + 14.06 * vitamin_b6 + 8.43 * vitamin_a + 14.41 * vitamin_b5 <= 151)
m.addConstr(16.22 * calcium + 17.19 * vitamin_b6 + 18.17 * vitamin_a + 14.31 * vitamin_b5 <= 163)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('calcium:', calcium.x)
    print('vitamin_b6:', vitamin_b6.x)
    print('vitamin_a:', vitamin_a.x)
    print('vitamin_b5:', vitamin_b5.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

