
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # milligrams of calcium
x2 = m.addVar(name="x2")  # milligrams of vitamin B6
x3 = m.addVar(name="x3", vtype=gp.GRB.INTEGER)  # milligrams of vitamin A
x4 = m.addVar(name="x4", vtype=gp.GRB.INTEGER)  # milligrams of vitamin B5

# Objective function
m.setObjective(1.27*x1*x2 + 9.65*x3**2 + 9.62*x2 + 4.91*x3 + 6.7*x4, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(8.07*x1 + 14.06*x2 >= 27)
m.addConstr(14.06**2*x2**2 + 8.43**2*x3**2 >= 35)
m.addConstr(8.07**2*x1**2 + 14.41**2*x4**2 >= 24)
m.addConstr(14.06**2*x2**2 + 14.41**2*x4**2 >= 26)
m.addConstr(14.06*x2 + 8.43*x3 + 14.41*x4 >= 32)
m.addConstr(8.07**2*x1**2 + 14.06**2*x2**2 + 14.41**2*x4**2 >= 32)
m.addConstr(8.07**2*x1**2 + 14.06**2*x2**2 + 8.43**2*x3**2 >= 32)
m.addConstr(14.06*x2 + 8.43*x3 + 14.41*x4 >= 20)
m.addConstr(8.07*x1 + 14.06*x2 + 14.41*x4 >= 20)
m.addConstr(8.07**2*x1**2 + 14.06**2*x2**2 + 8.43**2*x3**2 >= 20)
m.addConstr(14.06*x2 + 8.43*x3 + 14.41*x4 >= 20)
m.addConstr(8.07*x1 + 14.06*x2 + 14.41*x4 >= 20)
m.addConstr(8.07*x1 + 14.06*x2 + 8.43*x3 + 14.41*x4 >= 20)
m.addConstr(18.17*x3 + 14.31*x4 >= 37)
m.addConstr(17.19*x2 + 18.17*x3 >= 35)
m.addConstr(16.22*x1 + 18.17*x3 >= 13)
m.addConstr(16.22*x1 + 17.19*x2 >= 38)
m.addConstr(16.22**2*x1**2 + 14.41**2*x4**2 >= 18)
m.addConstr(17.19**2*x2**2 + 14.41**2*x4**2 >= 35)
m.addConstr(16.22*x1 + 17.19*x2 + 18.17*x3 + 14.31*x4 >= 35)
m.addConstr(-3*x2 + 7*x3 >= 0)
m.addConstr(-10*x1 + 8*x3 >= 0)
m.addConstr(8.43*x3 + 14.41*x4 <= 119)
m.addConstr(16.22*x1 + 17.19*x2 <= 47)
m.addConstr(16.22**2*x1**2 + 14.41**2*x4**2 <= 67)
m.addConstr(17.19**2*x2**2 + 18.17**2*x3**2 + 14.41**2*x4**2 <= 97)
m.addConstr(16.22*x1 + 17.19*x2 + 14.31*x4 <= 156)
m.addConstr(16.22**2*x1**2 + 17.19**2*x2**2 + 18.17**2*x3**2 <= 51)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible")
