
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="x2")


    # Set objective function
    model.setObjective(3.21*x0**2 + 7.72*x0*x1 + 2.32*x0*x2 + 6.24*x1**2 + 7.47*x1*x2 + 3.51*x2**2 + 5.19*x0 + 4.76*x2, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*x0 + 28*x1 >= 22, "c1")
    model.addConstr(8*x0 + 28*x1 >= 45, "c2")
    model.addConstr(8*x0 + 20*x2 >= 26, "c3")
    model.addConstr(28*x1 + 29*x2 >= 57, "c4")
    model.addConstr(10*x0 + 28*x1 <= 122, "c5")
    model.addConstr(28*x1 + 29*x2 <= 154, "c6")
    model.addConstr(10*x0 + 28*x1 + 29*x2 <= 85, "c7")
    model.addConstr(8*x0 + 28*x1 <= 160, "c8")
    model.addConstr(8*x0 + 20*x2 <= 76, "c9")
    model.addConstr(8*x0 + 28*x1 + 20*x2 <= 121, "c10")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
