
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Peggy
x1 = m.addVar(name="x1", lb=0)  # hours worked by John
x2 = m.addVar(name="x2", lb=0, integrality=gp.GRB.INTEGER)  # hours worked by Laura

# Define the objective function
m.setObjective(3.21*x0**2 + 7.72*x0*x1 + 2.32*x0*x2 + 6.24*x1**2 + 7.47*x1*x2 + 3.51*x2**2 + 5.19*x0 + 4.76*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x0 <= 193)
m.addConstr(8*x0 <= 179)
m.addConstr(28*x1 <= 193)
m.addConstr(28*x1 <= 179)
m.addConstr(29*x2 <= 193)
m.addConstr(20*x2 <= 179)
m.addConstr(28*x1 + 29*x2 >= 57)
m.addConstr(10*x0 + 28*x1 >= 22)
m.addConstr(8*x0 + 28*x1 >= 45)
m.addConstr(8*x0 + 20*x2 >= 26)
m.addConstr(28*x1 + 29*x2 <= 154)
m.addConstr(10*x0 + 28*x1 <= 122)
m.addConstr(10*x0 + 28*x1 + 29*x2 <= 85)
m.addConstr(28*x1 + 20*x2 <= 67)
m.addConstr(8*x0 + 28*x1 <= 160)
m.addConstr(8*x0 + 20*x2 <= 76)
m.addConstr(8*x0 + 28*x1 + 20*x2 <= 121)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Peggy: ", x0.varValue)
    print("Hours worked by John: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
