
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")
    x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milkshakes")


    # Set objective function
    m.setObjective(7*x0**2 + 7*x0*x1 + 9*x0*x2 + 2*x1**2 + 7*x1*x2 + 7*x2**2 + 8*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 8*x1 + 23*x2 >= 43, "protein_lower_bound")
    m.addConstr(3*x0 + 4*x2 >= 79, "carbohydrate_lower_bound_1")
    m.addConstr(6*x1**2 + 4*x2**2 >= 68, "carbohydrate_lower_bound_2")
    m.addConstr(4*x0**2 + 23*x2**2 <= 176, "protein_upper_bound_1")
    m.addConstr(4*x0**2 + 8*x1**2 <= 73, "protein_upper_bound_2")
    m.addConstr(4*x0 + 8*x1 + 23*x2 <= 73, "protein_upper_bound_3")
    m.addConstr(6*x1 + 4*x2 <= 85, "carbohydrate_upper_bound_1")
    m.addConstr(3*x0 + 4*x2 <= 164, "carbohydrate_upper_bound_2")
    m.addConstr(3*x0 + 6*x1 + 4*x2 <= 164, "carbohydrate_upper_bound_3")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('granola_bars:', x0.x)
        print('protein_bars:', x1.x)
        print('milkshakes:', x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
