
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="granola_bars", lb=0)
x1 = model.addVar(name="protein_bars", lb=0)
x2 = model.addVar(name="milkshakes", lb=0)

# Define the objective function
model.setObjective(7*x0**2 + 7*x0*x1 + 9*x0*x2 + 2*x1**2 + 7*x1*x2 + 7*x2**2 + 8*x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(4*x0 + 8*x1 + 23*x2 >= 43)
model.addConstr(3*x0 + 4*x2 >= 79)
model.addConstr(36*x1**2 + 16*x2**2 >= 68)
model.addConstr(16*x0**2 + 529*x2**2 <= 176)
model.addConstr(16*x0**2 + 64*x1**2 <= 73)
model.addConstr(4*x0 + 8*x1 + 23*x2 <= 73)
model.addConstr(6*x1 + 4*x2 <= 85)
model.addConstr(3*x0 + 4*x2 <= 164)
model.addConstr(3*x0 + 6*x1 + 4*x2 <= 164)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Granola bars: ", x0.x)
    print("Protein bars: ", x1.x)
    print("Milkshakes: ", x2.x)
else:
    print("The model is infeasible")
