
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Paul
x1 = m.addVar(name="x1", lb=0)  # hours worked by John
x2 = m.addVar(name="x2", lb=0)  # hours worked by George
x3 = m.addVar(name="x3", lb=0)  # hours worked by Jean

# Define the objective function
m.setObjective(8 * x0 + 5 * x1 + 5 * x2 + x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(11.95 * x0 <= 251)
m.addConstr(10.16 * x0 <= 115)
m.addConstr(0.14 * x0 <= 81)

m.addConstr(9.41 * x1 <= 251)
m.addConstr(1.95 * x1 <= 115)
m.addConstr(11.97 * x1 <= 81)

m.addConstr(1.0 * x2 <= 251)
m.addConstr(0.61 * x2 <= 115)
m.addConstr(10.43 * x2 <= 81)

m.addConstr(9.61 * x3 <= 251)
m.addConstr(5.35 * x3 <= 115)
m.addConstr(9.93 * x3 <= 81)

m.addConstr(9.41 * x1 + 9.61 * x3 >= 27)
m.addConstr(1.0 * x2 + 9.61 * x3 >= 21)
m.addConstr(9.41 * x1 + 1.0 * x2 >= 25)
m.addConstr(11.95 * x0 + 9.41 * x1 >= 47)
m.addConstr(11.95 * x0 + 1.0 * x2 + 9.61 * x3 >= 49)
m.addConstr(11.95 * x0 + 9.41 * x1 + 1.0 * x2 + 9.61 * x3 >= 49)

m.addConstr(10.16 * x0 + 5.35 * x3 >= 24)
m.addConstr(0.61 * x2 + 5.35 * x3 >= 17)
m.addConstr(1.95 * x1 + 5.35 * x3 >= 9)
m.addConstr(1.95 * x1 + 0.61 * x2 + 5.35 * x3 >= 28)
m.addConstr(10.16 * x0 + 1.95 * x1 + 5.35 * x3 >= 28)
m.addConstr(1.95 * x1 + 0.61 * x2 + 5.35 * x3 >= 28)
m.addConstr(10.16 * x0 + 1.95 * x1 + 5.35 * x3 >= 28)
m.addConstr(10.16 * x0 + 1.95 * x1 + 0.61 * x2 + 5.35 * x3 >= 28)

m.addConstr(10.43 * x2 + 9.93 * x3 >= 19)
m.addConstr(0.14 * x0 + 10.43 * x2 >= 20)
m.addConstr(11.97 * x1 + 9.93 * x3 >= 8)
m.addConstr(0.14 * x0 + 9.93 * x3 >= 9)
m.addConstr(0.14 * x0 + 11.97 * x1 + 10.43 * x2 >= 19)
m.addConstr(0.14 * x0 + 11.97 * x1 + 10.43 * x2 + 9.93 * x3 >= 19)

m.addConstr(6 * x0 - 8 * x2 >= 0)
m.addConstr(8 * x1 - 8 * x3 >= 0)

m.addConstr(11.95 * x0 + 9.41 * x1 + 9.61 * x3 <= 162)
m.addConstr(1.95 * x1 + 0.61 * x2 <= 89)
m.addConstr(1.95 * x1 + 0.61 * x2 + 5.35 * x3 <= 94)
m.addConstr(10.16 * x0 + 0.61 * x2 + 5.35 * x3 <= 89)
m.addConstr(10.16 * x0 + 1.95 * x1 + 0.61 * x2 <= 108)
m.addConstr(11.97 * x1 + 9.93 * x3 <= 32)
m.addConstr(0.14 * x0 + 10.43 * x2 <= 26)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
