
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
bottles_ibuprofen = m.addVar(vtype=GRB.INTEGER, name="bottles_ibuprofen")
cookies = m.addVar(vtype=GRB.INTEGER, name="cookies")

# Set objective function
m.setObjective(7.61 * bottles_ibuprofen + 4.87 * cookies, GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * bottles_ibuprofen + 16 * cookies >= 32, "portability_lower_bound")
m.addConstr(3 * bottles_ibuprofen - cookies >= 0, "ibuprofen_cookies_relation")
m.addConstr(19 * bottles_ibuprofen + 16 * cookies <= 95, "portability_upper_bound")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'bottles of ibuprofen: {bottles_ibuprofen.x}')
    print(f'cookies: {cookies.x}')
    print(f'Objective value: {m.objVal}')
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f'Optimization ended with status {m.status}')

