
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="bottles_of_ibuprofen")
x2 = m.addVar(vtype=GRB.INTEGER, name="cookies")

# Set the objective function
m.setObjective(7.61*x1 + 4.87*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(19*x1 + 16*x2 >= 32, "portability_rating_lower_bound")
m.addConstr(3*x1 - x2 >= 0, "linear_constraint")
m.addConstr(19*x1 + 16*x2 <= 95, "portability_rating_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bottles of ibuprofen: {x1.x}")
    print(f"Number of cookies: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
