
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bottles_of_ibuprofen", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cookies", vtype=gurobi.GRB.INTEGER)

    # Set the objective function
    model.setObjective(7.61 * x1 + 4.87 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(19 * x1 + 16 * x2 >= 32)
    model.addConstr(3 * x1 - x2 >= 0)
    model.addConstr(19 * x1 + 16 * x2 <= 95)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bottles of ibuprofen: {x1.varValue}")
        print(f"Cookies: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
