
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
john = m.addVar(vtype=gp.GRB.INTEGER, name="john")
bobby = m.addVar(vtype=gp.GRB.INTEGER, name="bobby")
peggy = m.addVar(vtype=gp.GRB.INTEGER, name="peggy")
ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")


# Set objective function
m.setObjective(9.56 * john + 4.75 * bobby + 9.42 * peggy + 4.98 * ringo, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.57 * bobby + 5.68 * ringo >= 45)
m.addConstr(1.25 * john + 1.57 * bobby >= 28)
m.addConstr(1.57 * bobby + 6.67 * peggy >= 28)
m.addConstr(7.88 * john + 8.32 * bobby + 1.31 * ringo >= 31)
m.addConstr(7.88 * john + 8.32 * bobby + 6.01 * peggy >= 31)
m.addConstr(8.32 * bobby + 6.01 * peggy + 1.31 * ringo >= 31)
m.addConstr(7.88 * john + 8.32 * bobby + 1.31 * ringo >= 24)
m.addConstr(7.88 * john + 8.32 * bobby + 6.01 * peggy >= 24)
m.addConstr(8.32 * bobby + 6.01 * peggy + 1.31 * ringo >= 24)
m.addConstr(5.1 * john + 7.48 * bobby >= 41)
m.addConstr(5.1 * john + 0.75 * ringo >= 80)
m.addConstr(1.25 * john + 5.68 * ringo <= 181)
m.addConstr(1.57 * bobby + 5.68 * ringo <= 118)
m.addConstr(1.57 * bobby + 6.67 * peggy <= 310)
m.addConstr(6.67 * peggy + 5.68 * ringo <= 177)
m.addConstr(1.25 * john + 1.57 * bobby + 6.67 * peggy + 5.68 * ringo <= 177)
m.addConstr(7.88 * john + 1.31 * ringo <= 121)
m.addConstr(6.01 * peggy + 1.31 * ringo <= 43)
m.addConstr(8.32 * bobby + 1.31 * ringo <= 36)
m.addConstr(7.88 * john + 8.32 * bobby <= 51)
m.addConstr(7.88 * john + 8.32 * bobby + 6.01 * peggy <= 117)
m.addConstr(7.88 * john + 8.32 * bobby + 6.01 * peggy + 1.31 * ringo <= 117)
m.addConstr(5.1 * john + 0.75 * ringo <= 167)
m.addConstr(0.37 * peggy + 0.75 * ringo <= 327)
m.addConstr(7.48 * bobby + 0.37 * peggy <= 176)
m.addConstr(5.1 * john + 0.37 * peggy <= 114)
m.addConstr(7.48 * bobby + 0.75 * ringo <= 326)
m.addConstr(5.1 * john + 7.48 * bobby + 0.37 * peggy + 0.75 * ringo <= 326)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

