
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by John
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Bobby
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo

    # Objective function
    model.setObjective(9.56 * x0 + 4.75 * x1 + 9.42 * x2 + 4.98 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1.57 * x1 + 5.68 * x3 >= 45)
    model.addConstr(1.25 * x0 + 1.57 * x1 >= 28)
    model.addConstr(1.57 * x1 + 6.67 * x2 >= 28)
    model.addConstr(7.88 * x0 + 8.32 * x1 + 1.31 * x3 >= 31)
    model.addConstr(7.88 * x0 + 8.32 * x1 + 6.01 * x2 >= 31)
    model.addConstr(8.32 * x1 + 6.01 * x2 + 1.31 * x3 >= 31)
    model.addConstr(7.88 * x0 + 8.32 * x1 + 1.31 * x3 >= 24)
    model.addConstr(7.88 * x0 + 8.32 * x1 + 6.01 * x2 >= 24)
    model.addConstr(8.32 * x1 + 6.01 * x2 + 1.31 * x3 >= 24)
    model.addConstr(7.88 * x0 + 8.32 * x1 + 1.31 * x3 >= 31)
    model.addConstr(7.88 * x0 + 8.32 * x1 + 6.01 * x2 >= 31)
    model.addConstr(8.32 * x1 + 6.01 * x2 + 1.31 * x3 >= 31)
    model.addConstr(5.1 * x0 + 7.48 * x1 >= 41)
    model.addConstr(5.1 * x0 + 0.75 * x3 >= 80)
    model.addConstr(1.25 * x0 + 5.68 * x3 <= 181)
    model.addConstr(1.57 * x1 + 5.68 * x3 <= 118)
    model.addConstr(1.57 * x1 + 6.67 * x2 <= 310)
    model.addConstr(6.67 * x2 + 5.68 * x3 <= 177)
    model.addConstr(1.25 * x0 + 1.57 * x1 + 6.67 * x2 + 5.68 * x3 <= 177)
    model.addConstr(7.88 * x0 + 1.31 * x3 <= 121)
    model.addConstr(6.01 * x2 + 1.31 * x3 <= 43)
    model.addConstr(8.32 * x1 + 1.31 * x3 <= 36)
    model.addConstr(7.88 * x0 + 8.32 * x1 <= 51)
    model.addConstr(7.88 * x0 + 8.32 * x1 + 6.01 * x2 <= 117)
    model.addConstr(7.88 * x0 + 8.32 * x1 + 6.01 * x2 + 1.31 * x3 <= 117)
    model.addConstr(5.1 * x0 + 0.75 * x3 <= 167)
    model.addConstr(0.37 * x2 + 0.75 * x3 <= 327)
    model.addConstr(7.48 * x1 + 0.37 * x2 <= 176)
    model.addConstr(5.1 * x0 + 0.37 * x2 <= 114)
    model.addConstr(7.48 * x1 + 0.75 * x3 <= 326)
    model.addConstr(5.1 * x0 + 7.48 * x1 + 0.37 * x2 + 0.75 * x3 <= 326)

    # Non-negativity constraints
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
