
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("corn_cobs_protein_bars")

# Create variables
corn_cobs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")
protein_bars = m.addVar(lb=0, vtype=GRB.INTEGER, name="protein_bars")


# Set objective function
m.setObjective(4 * corn_cobs + 4 * protein_bars, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * corn_cobs + 19 * protein_bars >= 26, "budget_min")
m.addConstr(6 * corn_cobs - 9 * protein_bars >= 0, "cob_protein_ratio")
m.addConstr(14 * corn_cobs + 19 * protein_bars <= 66, "budget_max")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Corn cobs: {corn_cobs.x}")
    print(f"Protein bars: {protein_bars.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

