
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="corn_cobs")
x2 = m.addVar(vtype=GRB.INTEGER, name="protein_bars")

# Set the objective function
m.setObjective(4*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 + 19*x2 >= 26, "min_cost")
m.addConstr(6*x1 - 9*x2 >= 0, "relationship_constraint")
m.addConstr(14*x1 + 19*x2 <= 66, "max_cost")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"corn_cobs: {x1.x}")
    print(f"protein_bars: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
