
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="corn_cobs", lb=0)  # corn cobs can be fractional
    x2 = model.addVar(name="protein_bars", lb=0, integrality=gurobi.GRB.INTEGER)  # protein bars must be an integer

    # Define the objective function
    model.setObjective(4*x1 + 4*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(14*x1 + 19*x2 >= 26, name="min_spend")
    model.addConstr(6*x1 - 9*x2 >= 0, name="min_corn_cobs")
    model.addConstr(14*x1 + 19*x2 <= 66, name="max_spend")

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Corn cobs: {x1.varValue}")
        print(f"Protein bars: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
