
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='wooden_pencils', vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name='smoke_detectors', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='mechanical_pencils', vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(1.14 * x0 + 7.94 * x1 + 2.93 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(x0 >= 0)
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x0 + 7 * x1 >= 15)
m.addConstr(x0 + 7 * x1 + 10 * x2 >= 21)
m.addConstr(8 * x0 + 3 * x1 + 5 * x2 >= 18)
m.addConstr(7 * x0 + 3 * x1 >= 11)
m.addConstr(3 * x1 + 9 * x2 >= 24)
m.addConstr(7 * x0 + 9 * x2 >= 14)
m.addConstr(7 * x0 + 3 * x1 + 9 * x2 >= 14)
m.addConstr(x1 + 11 * x2 >= 36)
m.addConstr(7 * x0 + x1 >= 23)
m.addConstr(7 * x0 + x1 + 11 * x2 >= 23)
m.addConstr(-5 * x0 + 3 * x2 >= 0)
m.addConstr(-7 * x1 + 10 * x2 >= 0)
m.addConstr(x0 + 7 * x1 <= 61)
m.addConstr(x0 + 10 * x2 <= 66)
m.addConstr(3 * x1 + 5 * x2 <= 29)
m.addConstr(8 * x0 + 5 * x2 <= 55)
m.addConstr(7 * x0 + 11 * x2 <= 87)
m.addConstr(x1 + 11 * x2 <= 47)
m.addConstr(7 * x0 + x1 + 11 * x2 <= 96)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('Wooden Pencils: ', x0.varValue)
    print('Smoke Detectors: ', x1.varValue)
    print('Mechanical Pencils: ', x2.varValue)
else:
    print('No solution found')
