
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Bobby
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Peggy


    # Set objective function
    model.setObjective(2.56 * x0 + 4.52 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(16 * x0 + 17 * x1 >= 25, "c0")
    model.addConstr(18 * x0 + 23 * x1 >= 51, "c1")
    model.addConstr(-8 * x0 + 6 * x1 >= 0, "c2")
    model.addConstr(16 * x0 + 17 * x1 <= 147, "c3")
    model.addConstr(18 * x0 + 23 * x1 <= 103, "c4")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == gp.GRB.OPTIMAL:
        print("Optimal solution found:")
        print(f"Hours worked by Bobby (x0): {x0.x}")
        print(f"Hours worked by Peggy (x1): {x1.x}")
        print(f"Objective value: {model.objVal}")
    else:
        print(f"Optimization terminated with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

