
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Bobby", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Peggy", lb=0)  # Assuming hours cannot be negative

    # Define objective function
    model.setObjective(2.56 * x1 + 4.52 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(16 * x1 + 17 * x2 >= 25, name="org_score_min")
    model.addConstr(18 * x1 + 23 * x2 >= 51, name="comp_comp_min")
    model.addConstr(-8 * x1 + 6 * x2 >= 0, name="mix_constraint")
    model.addConstr(16 * x1 + 17 * x2 <= 147, name="org_score_max")
    model.addConstr(18 * x1 + 23 * x2 <= 103, name="comp_comp_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bobby: {x1.varValue}")
        print(f"Hours worked by Peggy: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
