
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("productivity_optimization")

    # Create variables
    hank_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")
    peggy_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy_hours")
    bill_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="bill_hours")


    # Set objective function
    model.setObjective(7*hank_hours**2 + 4*hank_hours*peggy_hours + 9*peggy_hours**2 + 8*peggy_hours*bill_hours + 9*bill_hours**2 + 2*hank_hours + 2*peggy_hours + 7*bill_hours, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.25*hank_hours + 1.22*peggy_hours >= 46, "c1")
    model.addConstr(0.25*hank_hours + 1.22*peggy_hours <= 176, "c2")
    model.addConstr(1.22*peggy_hours + 0.39*bill_hours >= 71, "c3")
    model.addConstr(1.22*peggy_hours + 0.39*bill_hours <= 199, "c4")
    model.addConstr(0.25*hank_hours + 1.22*peggy_hours + 0.39*bill_hours >= 51, "c5")
    model.addConstr(0.25*hank_hours + 1.22*peggy_hours + 0.39*bill_hours <= 98, "c6")
    model.addConstr(0.25*hank_hours + 0.39*bill_hours <= 98, "c7")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Hank Hours: %g' % hank_hours.x)
        print('Peggy Hours: %g' % peggy_hours.x)
        print('Bill Hours: %g' % bill_hours.x)
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
