
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Hank", lb=-GRB.INFINITY, ub=GRB.INFINITY)
x2 = m.addVar(name="hours_worked_by_Peggy", lb=-GRB.INFINITY, ub=GRB.INFINITY)
x3 = m.addVar(name="hours_worked_by_Bill", lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.INTEGER)

# Objective function
m.setObjective(7*x1**2 + 4*x1*x2 + 9*x2**2 + 8*x2*x3 + 9*x3**2 + 2*x1 + 2*x2 + 7*x3, GRB.MAXIMIZE)

# Constraints
m.addConstr(0.25*x1 <= 235)
m.addConstr(1.22*x2 <= 235)
m.addConstr(0.39*x3 <= 235)
m.addConstr(1.22*x2 + 0.39*x3 >= 71)
m.addConstr(0.25*x1 + 1.22*x2 >= 46)
m.addConstr(0.25*x1 + 1.22*x2 + 0.39*x3 >= 51)
m.addConstr(1.22*x2 + 0.39*x3 <= 199)
m.addConstr(0.25*x1 + 1.22*x2 <= 176)
m.addConstr(0.25*x1 + 0.39*x3 <= 98)
m.addConstr(0.25*x1 + 1.22*x2 + 0.39*x3 <= 98)

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {x1.varValue}")
    print(f"Hours worked by Peggy: {x2.varValue}")
    print(f"Hours worked by Bill: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
