
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Peggy
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1") # hours worked by Bobby
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Dale


    # Set objective function
    model.setObjective(9.64*x0**2 + 7.83*x0*x2 + 4.68*x0 + 2.93*x1 + 6.99*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14*x0 == 14, "c0")
    model.addConstr(2*x1 == 2, "c1")
    model.addConstr(5*x2 == 5, "c2")
    model.addConstr(14*x0**2 + 2*x1**2 >= 13, "c3")
    model.addConstr(2*x1 + 5*x2 >= 9, "c4")
    model.addConstr(14*x0 + 2*x1 + 5*x2 >= 16, "c5")
    model.addConstr(-10*x1**2 + 6*x2**2 >= 0, "c6")
    model.addConstr(2*x1 + 5*x2 <= 20, "c7")
    model.addConstr(14*x0 + 2*x1 <= 53, "c8")
    model.addConstr(14*x0 + 2*x1 + 5*x2 <= 43, "c9")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("x0 (hours worked by Peggy):", x0.x)
        print("x1 (hours worked by Bobby):", x1.x)
        print("x2 (hours worked by Dale):", x2.x)

except gp.GurobiError as e:
    print("Error code " + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
