
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Bobby
    x3 = model.addVar(name="x3")  # hours worked by Dale

    # Objective function
    model.setObjective(9.64 * x1**2 + 7.83 * x1 * x3 + 4.68 * x1 + 2.93 * x2 + 6.99 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14 * x1**2 + 2 * x2**2 >= 13)
    model.addConstr(2 * x2 + 5 * x3 >= 9)
    model.addConstr(14 * x1 + 2 * x2 + 5 * x3 >= 16)
    model.addConstr(-10 * x2**2 + 6 * x3**2 >= 0)
    model.addConstr(2 * x2 + 5 * x3 <= 20)
    model.addConstr(14 * x1 + 2 * x2 <= 53)
    model.addConstr(14 * x1 + 2 * x2 + 5 * x3 <= 43)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Peggy: {x1.varValue}")
        print(f"Hours worked by Bobby: {x2.varValue}")
        print(f"Hours worked by Dale: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
