
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
system_administrators = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
deployed_decoys = m.addVar(vtype=GRB.INTEGER, name="deployed_decoys")
automatic_alerts = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security_engineers")


# Set objective function
m.setObjective(6*pen_testers + 1*system_administrators + 6*deployed_decoys + 6*automatic_alerts + 7*security_engineers, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*pen_testers + 8*system_administrators + 1*deployed_decoys + 8*automatic_alerts + 5*security_engineers <= 219, "c1")
m.addConstr(11*pen_testers + 8*system_administrators + 9*deployed_decoys + 11*automatic_alerts + 9*security_engineers <= 218, "c2")
m.addConstr(4*pen_testers + 14*system_administrators + 1*deployed_decoys + 3*automatic_alerts + 3*security_engineers <= 249, "c3")

m.addConstr(6*pen_testers + 5*security_engineers >= 18, "c4")
m.addConstr(1*deployed_decoys + 5*security_engineers >= 18, "c5")
m.addConstr(8*system_administrators + 8*automatic_alerts >= 39, "c6")
m.addConstr(1*deployed_decoys + 8*automatic_alerts >= 43, "c7")
m.addConstr(6*pen_testers + 8*system_administrators + 1*deployed_decoys + 8*automatic_alerts + 5*security_engineers >= 43, "c8")

m.addConstr(8*system_administrators + 11*automatic_alerts >= 40, "c9")
m.addConstr(9*deployed_decoys + 9*security_engineers >= 28, "c10")
m.addConstr(11*automatic_alerts + 9*security_engineers >= 15, "c11")
m.addConstr(8*system_administrators + 9*security_engineers >= 14, "c12")
m.addConstr(11*pen_testers + 9*deployed_decoys >= 26, "c13")
m.addConstr(9*deployed_decoys + 11*automatic_alerts >= 14, "c14")
m.addConstr(11*pen_testers + 8*system_administrators + 9*deployed_decoys + 11*automatic_alerts + 9*security_engineers >= 14, "c15")


m.addConstr(4*pen_testers + 3*security_engineers >= 30, "c16")
m.addConstr(1*deployed_decoys + 3*automatic_alerts >= 42, "c17")
m.addConstr(4*pen_testers + 3*automatic_alerts >= 17, "c18")
m.addConstr(1*deployed_decoys + 3*security_engineers >= 33, "c19")
m.addConstr(3*automatic_alerts + 3*security_engineers >= 40, "c20")
m.addConstr(4*pen_testers + 14*system_administrators + 1*deployed_decoys + 3*automatic_alerts + 3*security_engineers >= 40, "c21")

m.addConstr(6*pen_testers + 8*system_administrators + 5*security_engineers <= 160, "c22")
m.addConstr(6*pen_testers + 8*automatic_alerts + 5*security_engineers <= 129, "c23")
m.addConstr(8*system_administrators + 1*deployed_decoys + 5*security_engineers <= 98, "c24")

m.addConstr(11*pen_testers + 8*system_administrators + 9*deployed_decoys <= 157, "c25")
m.addConstr(11*pen_testers + 8*system_administrators + 11*automatic_alerts <= 65, "c26")
m.addConstr(11*pen_testers + 11*automatic_alerts + 9*security_engineers <= 215, "c27")

m.addConstr(14*system_administrators + 1*deployed_decoys <= 190, "c28")
m.addConstr(14*system_administrators + 3*security_engineers <= 164, "c29")
m.addConstr(4*pen_testers + 14*system_administrators <= 221, "c30")
m.addConstr(14*system_administrators + 3*automatic_alerts <= 248, "c31")
m.addConstr(4*pen_testers + 3*automatic_alerts <= 226, "c32")
m.addConstr(4*pen_testers + 3*security_engineers <= 219, "c33")
m.addConstr(4*pen_testers + 1*deployed_decoys + 3*automatic_alerts <= 196, "c34")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

