
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # pen testers
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # system administrators
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # deployed decoys
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # automatic alerts
    x4 = model.addVar(name="x4", vtype=gurobi.GRB.INTEGER)  # security engineers

    # Objective function
    model.setObjective(6 * x0 + (x1 + 6) * x2 + 6 * x3 + 7 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6 * x0 <= 219)
    model.addConstr(11 * x0 <= 218)
    model.addConstr(4 * x0 <= 249)
    model.addConstr(8 * x1 <= 219)
    model.addConstr(8 * x1 <= 218)
    model.addConstr(14 * x1 <= 249)
    model.addConstr(x2 <= 219)
    model.addConstr(9 * x2 <= 218)
    model.addConstr(x2 <= 249)
    model.addConstr(8 * x3 <= 219)
    model.addConstr(11 * x3 <= 218)
    model.addConstr(3 * x3 <= 249)
    model.addConstr(5 * x4 <= 219)
    model.addConstr(9 * x4 <= 218)
    model.addConstr(3 * x4 <= 249)
    model.addConstr(6 * x0 + 8 * x1 + 5 * x4 >= 18)
    model.addConstr(x2 + 5 * x4 >= 18)
    model.addConstr(8 * x1 + 8 * x3 >= 39)
    model.addConstr(x2 + 8 * x3 >= 43)
    model.addConstr(6 * x0 + 8 * x1 + x2 + 8 * x3 + 5 * x4 >= 43)
    model.addConstr(8 * x1 + 11 * x3 >= 40)
    model.addConstr(9 * x2 + 9 * x4 >= 28)
    model.addConstr(11 * x3 + 9 * x4 >= 15)
    model.addConstr(8 * x1 + 9 * x4 >= 14)
    model.addConstr(11 * x0 + 9 * x2 >= 26)
    model.addConstr(9 * x2 + 11 * x3 >= 14)
    model.addConstr(11 * x0 + 8 * x1 + 9 * x2 + 11 * x3 + 9 * x4 >= 14)
    model.addConstr(4 * x0 + 3 * x4 >= 30)
    model.addConstr(x2 + 3 * x3 >= 42)
    model.addConstr(4 * x0 + 3 * x3 >= 17)
    model.addConstr(x2 + 3 * x4 >= 33)
    model.addConstr(3 * x3 + 3 * x4 >= 40)
    model.addConstr(4 * x0 + 14 * x1 + x2 + 3 * x3 + 3 * x4 >= 40)
    model.addConstr(6 * x0 + 8 * x1 + 5 * x4 <= 160)
    model.addConstr(6 * x0 + 8 * x3 + 5 * x4 <= 129)
    model.addConstr(8 * x1 + x2 + 5 * x4 <= 98)
    model.addConstr(11 * x0 + 8 * x1 + 9 * x2 <= 157)
    model.addConstr(11 * x0 + 8 * x1 + 11 * x3 <= 65)
    model.addConstr(11 * x0 + 11 * x3 + 9 * x4 <= 215)
    model.addConstr(14 * x1 + x2 <= 190)
    model.addConstr(14 * x1 + 3 * x4 <= 164)
    model.addConstr(4 * x0 + 14 * x1 <= 221)
    model.addConstr(14 * x1 + 3 * x3 <= 248)
    model.addConstr(4 * x0 + 3 * x3 <= 226)
    model.addConstr(4 * x0 + 3 * x4 <= 219)
    model.addConstr(4 * x0 + x2 + 3 * x3 <= 196)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
