
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Work_Hours")

# Create variables
john_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
paul_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")


# Set objective function
model.setObjective(9 * john_hours + 8 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * john_hours + 4 * paul_hours >= 41, "organization_score_min")
model.addConstr(9 * john_hours + 2 * paul_hours >= 18, "paperwork_min")
model.addConstr(11 * john_hours + 3 * paul_hours >= 24, "work_quality_min")
model.addConstr(7 * john_hours - 5 * paul_hours >= 0, "john_paul_relation")
model.addConstr(5 * john_hours + 4 * paul_hours <= 93, "organization_score_max")
model.addConstr(9 * john_hours + 2 * paul_hours <= 59, "paperwork_max")
model.addConstr(11 * john_hours + 3 * paul_hours <= 60, "work_quality_max")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  John's hours: {john_hours.x}")
    print(f"  Paul's hours: {paul_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

