
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_John", lb=0)
x2 = m.addVar(name="hours_worked_by_Paul", lb=0)

# Set the objective function
m.setObjective(9*x1 + 8*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 >= 41, name="organization_score_lower_bound")
m.addConstr(9*x1 + 2*x2 >= 18, name="paperwork_competence_rating_lower_bound")
m.addConstr(11*x1 + 3*x2 >= 24, name="work_quality_rating_lower_bound")
m.addConstr(7*x1 - 5*x2 >= 0, name="linear_combination_constraint")
m.addConstr(5*x1 + 4*x2 <= 93, name="organization_score_upper_bound")
m.addConstr(9*x1 + 2*x2 <= 59, name="paperwork_competence_rating_upper_bound")
m.addConstr(11*x1 + 3*x2 <= 60, name="work_quality_rating_upper_bound")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by John: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
