
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='hours_worked_by_John', lb=0)  # Assuming non-negative hours
x2 = m.addVar(name='hours_worked_by_Paul', lb=0)

# Objective function
m.setObjective(9 * x1 + 8 * x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5 * x1 == 5, name='John_organization_score')
m.addConstr(9 * x1 == 9, name='John_paperwork_competence_rating')
m.addConstr(11 * x1 == 11, name='John_work_quality_rating')
m.addConstr(4 * x2 == 4, name='Paul_organization_score')
m.addConstr(2 * x2 == 2, name='Paul_paperwork_competence_rating')
m.addConstr(3 * x2 == 3, name='Paul_work_quality_rating')

m.addConstr(5 * x1 + 4 * x2 >= 41, name='total_organization_score')
m.addConstr(9 * x1 + 2 * x2 >= 18, name='total_paperwork_competence_rating')
m.addConstr(11 * x1 + 3 * x2 >= 24, name='total_work_quality_rating')

m.addConstr(7 * x1 - 5 * x2 >= 0, name='hours_worked_constraint')

m.addConstr(5 * x1 + 4 * x2 <= 113, name='organization_score_upper_bound')
m.addConstr(9 * x1 + 2 * x2 <= 60, name='paperwork_competence_rating_upper_bound')
m.addConstr(11 * x1 + 3 * x2 <= 60, name='work_quality_rating_upper_bound')

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Optimal solution found.')
    print('Hours worked by John: ', x1.varValue)
    print('Hours worked by Paul: ', x2.varValue)
    print('Objective: ', m.objVal)
else:
    print('No optimal solution found.')
