
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knishes")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")


# Set objective function
m.setObjective(5.44 * x0 + 3.15 * x1 + 5.25 * x2 + 4.51 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * x0 + 12 * x1 >= 76)
m.addConstr(3 * x0 + 9 * x2 + 4 * x3 >= 29)
m.addConstr(3 * x0 + 10 * x1 + 9 * x2 >= 29)
m.addConstr(10 * x1 + 9 * x2 + 4 * x3 >= 29)
m.addConstr(12 * x0 + 12 * x1 + x2 >= 70)
m.addConstr(12 * x0 + x2 + 4 * x3 >= 70)
m.addConstr(12 * x0 + 12 * x1 + x2 >= 38)
m.addConstr(12 * x0 + x2 + 4 * x3 >= 38)
m.addConstr(8 * x0 + 5 * x3 <= 88)
m.addConstr(12 * x1 + 5 * x3 <= 223)
m.addConstr(8 * x0 + 11 * x2 <= 83)
m.addConstr(11 * x2 + 5 * x3 <= 138)
m.addConstr(8 * x0 + 12 * x1 + 11 * x2 + 5 * x3 <= 138)
m.addConstr(3 * x0 + 12 * x1 <= 265)
m.addConstr(4 * x2 + 4 * x3 <= 331)
m.addConstr(3 * x0 + 4 * x2 <= 256)
m.addConstr(12 * x1 + 4 * x3 <= 347)
m.addConstr(3 * x0 + 12 * x1 + 4 * x2 <= 176)
m.addConstr(3 * x0 + 4 * x2 + 4 * x3 <= 285)
m.addConstr(3 * x0 + 12 * x1 + 4 * x2 + 4 * x3 <= 285)
m.addConstr(3 * x0 + 9 * x2 <= 66)
m.addConstr(10 * x1 + 4 * x3 <= 112)
m.addConstr(3 * x0 + 10 * x1 + 9 * x2 <= 73)
m.addConstr(3 * x0 + 9 * x2 + 4 * x3 <= 112)
m.addConstr(10 * x1 + 9 * x2 + 4 * x3 <= 68)
m.addConstr(3 * x0 + 10 * x1 + 9 * x2 + 4 * x3 <= 68)
m.addConstr(12 * x0 + 4 * x3 <= 119)
m.addConstr(12 * x1 + 4 * x3 <= 160)
m.addConstr(12 * x1 + x2 + 4 * x3 <= 245)
m.addConstr(12 * x0 + 12 * x1 + x2 + 4 * x3 <= 245)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

