
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="fruit_salads", lb=0)
    x1 = model.addVar(name="oranges", lb=0)
    x2 = model.addVar(name="knishes", lb=0)
    x3 = model.addVar(name="slices_of_pizza", lb=0)

    # Objective function
    model.setObjective(5.44 * x0 + 3.15 * x1 + 5.25 * x2 + 4.51 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8 * x0 + 12 * x1 + 11 * x2 + 5 * x3 <= 323)
    model.addConstr(3 * x0 + 12 * x1 + 4 * x2 + 4 * x3 <= 389)
    model.addConstr(3 * x0 + 10 * x1 + 9 * x2 + 4 * x3 <= 121)
    model.addConstr(12 * x0 + 12 * x1 + x2 + 4 * x3 <= 289)
    model.addConstr(3 * x0 + 12 * x1 >= 76)
    model.addConstr(3 * x0 + 9 * x2 + 4 * x3 >= 29)
    model.addConstr(3 * x0 + 10 * x1 + 9 * x2 >= 29)
    model.addConstr(10 * x1 + 9 * x2 + 4 * x3 >= 29)
    model.addConstr(3 * x0 + 9 * x2 + 4 * x3 >= 24)
    model.addConstr(3 * x0 + 10 * x1 + 9 * x2 >= 24)
    model.addConstr(10 * x1 + 9 * x2 + 4 * x3 >= 24)
    model.addConstr(12 * x0 + 12 * x1 + x2 >= 70)
    model.addConstr(12 * x0 + x2 + 4 * x3 >= 70)
    model.addConstr(12 * x0 + 12 * x1 + x2 >= 38)
    model.addConstr(12 * x0 + x2 + 4 * x3 >= 38)
    model.addConstr(8 * x0 + 5 * x3 <= 88)
    model.addConstr(12 * x1 + 5 * x3 <= 223)
    model.addConstr(8 * x0 + 11 * x2 <= 83)
    model.addConstr(11 * x2 + 5 * x3 <= 138)
    model.addConstr(8 * x0 + 12 * x1 + 11 * x2 + 5 * x3 <= 138)
    model.addConstr(3 * x0 + 12 * x1 <= 265)
    model.addConstr(4 * x2 + 4 * x3 <= 331)
    model.addConstr(3 * x0 + 4 * x2 <= 256)
    model.addConstr(12 * x1 + 4 * x3 <= 347)
    model.addConstr(3 * x0 + 12 * x1 + 4 * x2 <= 176)
    model.addConstr(3 * x0 + 4 * x2 + 4 * x3 <= 285)
    model.addConstr(3 * x0 + 12 * x1 + 4 * x2 + 4 * x3 <= 285)
    model.addConstr(3 * x0 + 9 * x2 <= 66)
    model.addConstr(10 * x1 + 4 * x3 <= 112)
    model.addConstr(3 * x0 + 10 * x1 + 9 * x2 <= 73)
    model.addConstr(3 * x0 + 9 * x2 + 4 * x3 <= 112)
    model.addConstr(10 * x1 + 9 * x2 + 4 * x3 <= 68)
    model.addConstr(3 * x0 + 10 * x1 + 9 * x2 + 4 * x3 <= 68)
    model.addConstr(12 * x0 + 4 * x3 <= 119)
    model.addConstr(12 * x1 + 4 * x3 <= 160)
    model.addConstr(12 * x1 + x2 + 4 * x3 <= 245)
    model.addConstr(12 * x0 + 12 * x1 + x2 + 4 * x3 <= 245)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Fruit Salads: ", x0.varValue)
        print("Oranges: ", x1.varValue)
        print("Knishes: ", x2.varValue)
        print("Slices of Pizza: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
