
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Bill", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="hours_worked_by_Ringo", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="hours_worked_by_Mary", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x4 = model.addVar(name="hours_worked_by_John", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(3*x1**2 + 2*x1*x2 + 9*x1*x3 + 2*x1*x4 + 4*x2**2 + 7*x2*x3 + 5*x2*x4 + x3*x4 + 2*x4**2 + 2*x1 + 4*x3 + 8*x4)

    # Constraints
    model.addConstr(6*x1 == 6, name="Bill_computer_competence")
    model.addConstr(20*x2 == 20, name="Ringo_computer_competence")
    model.addConstr(5*x3 == 5, name="Mary_computer_competence")
    model.addConstr(3*x4 == 3, name="John_computer_competence")

    model.addConstr(6*x1 + 3*x4 >= 19, name="Bill_John_total")
    model.addConstr(20*x2 + 3*x4 >= 30, name="Ringo_John_total")
    model.addConstr(20*x2 + 5*x3 >= 39, name="Ringo_Mary_total")
    model.addConstr(6*x1 + 20*x2 + 5*x3 + 3*x4 >= 39, name="All_total")

    model.addConstr(-x2**2 + 9*x3**2 >= 0, name="Ringo_Mary_constraint")
    model.addConstr(-9*x2 + 9*x4 >= 0, name="Ringo_John_constraint")
    model.addConstr(5*x1 - 2*x3 >= 0, name="Bill_Mary_constraint")

    model.addConstr(6*x1 + 3*x4 <= 201, name="Bill_John_limit")
    model.addConstr(20*x2 + 3*x4 <= 189, name="Ringo_John_limit")
    model.addConstr(20*x2 + 5*x3 + 3*x4 <= 95, name="Ringo_Mary_John_limit")
    model.addConstr(6*x1 + 20*x2 + 5*x3 <= 110, name="Bill_Ringo_Mary_limit")
    model.addConstr(6*x1 + 5*x3 + 3*x4 <= 88, name="Bill_Mary_John_limit")

    # Solve the problem
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Hours worked by Mary: {x3.varValue}")
        print(f"Hours worked by John: {x4.varValue}")
    else:
        print("No optimal solution found.")

optimize_problem()
